export default function once(emitter, name, { signal } = {}) {
    return new Promise((resolve, reject) => {
        function cleanup() {
            signal === null || signal === void 0 ? void 0 : signal.removeEventListener('abort', cleanup);
            emitter.removeListener(name, onEvent);
            emitter.removeListener('error', onError);
        }
        function onEvent(...args) {
            cleanup();
            resolve(args);
        }
        function onError(err) {
            cleanup();
            reject(err);
        }
        signal === null || signal === void 0 ? void 0 : signal.addEventListener('abort', cleanup);
        emitter.on(name, onEvent);
        emitter.on('error', onError);
    });
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/618725e67565b290ba4da6fe2d29f8fa1d4e3622/node_modules/@tootallnate/once/dist/index.js.map